<?php

namespace App\Console\Commands\Ebay;

use App\Integrations\Ebay;
use App\Models\SalesChannel;
use Illuminate\Console\Command;

class RefreshEbayAccessToken extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:ebay:refresh-access-token {salesChannel}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Refresh ebay access token for specific sales channel.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @throws \Exception
     */
    public function handle(): void
    {
        $sales_channel = SalesChannel::with('type')
            ->findOrFail($this->argument('salesChannel'));
        if ($sales_channel->sales_channel_type_id != 2) {
            $this->error('Sales Channel must be Ebay type.');

            return;
        }
        $access_token = ( new Ebay($sales_channel->credentials) )
            ->refreshAccessToken($sales_channel->integration_settings['refresh_token']);

        $integration_settings = $sales_channel->integration_settings;
        $integration_settings['access_token'] = $access_token['access_token'];

        $sales_channel->integration_settings = $integration_settings;
        $sales_channel->save();

        $this->info('Access token refreshed.');
    }
}
