<?php

namespace App\Console\Commands;

use App\Models\Address;
use App\Models\Customer;
use App\Models\SalesCredit;
use App\Models\SalesOrder;
use Illuminate\Console\Command;

class DeleteDuplicateCustomers extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'patch:delete-duplicate-customers';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Delete duplicate customer records';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $uniqueFields = [
            'name',
            'email',
            'zip',
            'address1',
        ];

        $customerClassMappings = [
            SalesOrder::class => ["customer_id"],
            SalesCredit::class => ["customer_id"]
        ];

        $select = "";
        foreach ($uniqueFields as $field){
            $select .= "COALESCE($field, '') as $field,";
        }
        $select = rtrim($select, ',');

        $customersWithDuplications = Customer::query()
            ->selectRaw($select)
            ->groupBy('hash')
            ->havingRaw('COUNT(*) > 1')
            ->get();

        $customersWithDuplications->each(function ($customer) use ($customerClassMappings, $uniqueFields) {
            $customerUsagesQuery = Customer::query();

            foreach ($uniqueFields as $field) {
                if (!empty($customer->$field)) {
                    $customerUsagesQuery->where($field, $customer->$field);
                } else {
                    $customerUsagesQuery->where(function ($query) use ($field) {
                        $query->whereNull($field)->orWhere($field, '')->orWhere($field, 0);
                    });
                }
            }

            $customerUsagesQuery->orderBy('id');

            $customerUsages = $customerUsagesQuery->get();

            if ($customerUsages->count() === 0) {
                $this->output->warning("No customer usages found for customer with the following query: " . $customerUsagesQuery->toSqlWithBindings());
                return false;
            }

            $customerIdToKeep = $customerUsages->first()->id;
            $customerIdsToDelete = $customerUsages->skip(1)->pluck('id');
            customlog("delete_duplicate_customers", "Customer ID to keep: {$customerIdToKeep}, Deleting " . $customerIdsToDelete->count() . " customers");

            foreach ($customerClassMappings as $modelClass => $customerIdColumns) {
                foreach ($customerIdColumns as $customerIdColumn) {
                    app($modelClass)->whereIn($customerIdColumn, $customerIdsToDelete)->update([
                        $customerIdColumn => $customerIdToKeep
                    ]);
                }
            }

            Customer::whereIn('id', $customerIdsToDelete)->delete();
        });
    }
}
