<?php

namespace App\Console\Commands;

use App\Models\SalesOrder;
use Illuminate\Console\Command;

class BulkChangeOrderStatus extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:bulk-change-order-status
                              {--status= : open or draft}
                              {--ids= : ids (space separated) of sales orders}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Change order status for sales orders in bulk';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $status = $this->option('status');
        $ids = explode(',', $this->option('ids'));

        foreach ($ids as $id) {
            $salesOrder = SalesOrder::with([])->findOrFail($id);
            $this->output->text("Processing $salesOrder->customer_reference ($id), converting to $status");
            if ($status == 'open') {
                if ($salesOrder->order_status == 'open') {
                    continue;
                }
                $salesOrder->approve();
            } elseif ($status == 'draft') {
                if ($salesOrder->order_status == 'draft') {
                    continue;
                }
                if (is_array($revertToDraftError = $salesOrder->revertToDraft())) {
                    $this->error($revertToDraftError[0]);
                }
            }
        }
    }
}
