<?php

namespace App\Console\Commands\Accounting;

use App\Jobs\Accounting\SyncAccountingTransactionsJob;
use Illuminate\Console\Command;

class SyncAccountingTransactionsCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:accounting:transactions:sync 
                                        {--ids=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync Accounting Transactions';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $ids = $this->option('ids') ? explode(',', $this->option('ids')) : [];
        dispatch(new SyncAccountingTransactionsJob($ids))->onQueue('accounting');
    }
}
