<?php

namespace App\Console\Commands;

use App\Repositories\IntegrationInstanceRepository;
use Illuminate\Console\Command;
use Illuminate\Support\Collection;

abstract class AbstractIntegrationInstanceCommand extends Command
{
    protected IntegrationInstanceRepository $integrationInstanceRepository;

    protected Collection $integrationInstances;

    public function __construct()
    {
        parent::__construct();
        $this->integrationInstanceRepository = app(IntegrationInstanceRepository::class);
    }

    protected function integrationInstances(): Collection
    {
        $integrationInstanceId = $this->argument('integrationInstanceId');
        if ($integrationInstanceId !== null) {
            // If integrationInstanceId is provided, return a collection with a single instance
            return collect([$this->integrationInstanceRepository->getById($integrationInstanceId)]);
        }

        // If no integrationInstanceId is provided, return all instances
        return $this->integrationInstanceRepository->all();
    }
}
