<?php

namespace App\Actions;

use App\Repositories\InventoryMovementRepository;
use App\Repositories\InventorySnapshotRepository;

class TakeInventorySnapshot
{
    protected array $productIds;

    protected InventoryMovementRepository $inventoryMovementRepository;

    protected InventorySnapshotRepository $inventorySnapshotRepository;

    public function __construct(array $productIds = [])
    {
        $this->inventoryMovementRepository = app(InventoryMovementRepository::class);
        $this->inventorySnapshotRepository = app(InventorySnapshotRepository::class);
        $this->productIds = $productIds;
    }

    public function handle(): void
    {
        return;

        // Necessary due to possibility of deleted movements
        $this->inventorySnapshotRepository->purgeInvalidSnapshots($this->productIds);

        /*
         * Seeding inventory snapshots for each missing product date with an inventory movement
         * We only seed dates that have inventory movements for a product.  So if a product has inventory movements
         * 3 years apart, we don't seed 365 * 3 worth of data, just 2 rows
         */
        $this->inventorySnapshotRepository->seed($this->productIds);

        // Get product ids that have at least 1 invalid snapshot, chunked 10,000 product ids at a time
        foreach ($this->inventorySnapshotRepository->getProductIdsWithInvalidCache($this->productIds)->chunk(10000) as $chunk) {
            /*
             * Delete any valid snapshots that exist after the oldest invalid snapshot for a product.  This case should
             * not exist, but we do this as a safety measure.
             */
            $this->inventorySnapshotRepository->sanitizeValidSnapshots($chunk);

            /*
             * Builds validated inventory snapshot data from a combination of previous validated snapshots and new
             * data built from inventory movements
             */
            $data = $this->inventorySnapshotRepository->getNewlyValidatedData($chunk);

            if (empty($data)) {
                return;
            }

            $this->inventorySnapshotRepository->saveBulk($data);
            unset($data);
        }
    }
}
