<?php

namespace App\Actions;

use App\Data\FinancialLineData;
use App\Models\FinancialLine;
use App\Models\FinancialLineType;
use App\Models\SalesOrderFulfillmentLine;
use App\Models\SalesOrderLine;
use App\Repositories\FinancialLineRepository;
use Exception;

class ConvertSalesOrderLineToFinancialLine
{
    public function __construct(
        private readonly FinancialLineRepository $financialLines,
    )
    {
    }

    /**
     * @throws Exception
     */
    public function __invoke(
        SalesOrderLine $salesOrderLine,
        FinancialLineType $financialLineType
    ): void
    {
        $data = FinancialLineData::from([
            'sales_order_id' => $salesOrderLine->sales_order_id,
            'financial_line_type_id' => $financialLineType->id,
            'nominal_code_id' => $salesOrderLine->nominal_code_id,
            'description' => $salesOrderLine->description,
            'quantity' => $salesOrderLine->quantity,
            'amount' => $salesOrderLine->amount,
            'tax_rate_id' => $salesOrderLine->tax_rate_id,
            'tax_rate' => $salesOrderLine->tax_rate,
            'tax_allocation' => $salesOrderLine->tax_allocation,
            'allocate_to_products' => $financialLineType->allocate_to_products,
            'proration_strategy' => $financialLineType->proration_strategy,
            'sales_channel_line_id' => $salesOrderLine->sales_channel_line_id,
        ]);

        $salesOrder = $salesOrderLine->salesOrder;
        $orderStatus = $salesOrder->order_status;
        $fulfillmentStatus = $salesOrder->fulfillment_status;
        $this->financialLines->save($data, FinancialLine::class);
        $salesOrderLine->salesOrderFulfillmentLines->each(function (SalesOrderFulfillmentLine $salesOrderFulfillmentLine) {
            $salesOrderFulfillmentLine->delete();
        });
        $salesOrderLine->delete();
        $salesOrder->refresh();
        $salesOrder->order_status = $orderStatus;
        $salesOrder->fulfillment_status = $fulfillmentStatus;
        $salesOrder->save();
    }
}
