<?php

namespace App\Actions;

use App\Helpers;
use App\Jobs\InventorySnapshotJob;
use App\Models\InventorySnapshot;
use App\Models\Product;
use App\Models\Setting;
use App\Repositories\InventorySnapshotRepository;
use App\Repositories\ProductRepository;
use Carbon\Carbon;
use Illuminate\Support\Arr;

class CacheDailyAverageConsumptionForProducts
{
    private array $productIds;

    private ProductRepository $productRepository;

//    private InventorySnapshotRepository $inventorySnapshotRepository;

    public function __construct(array $productIds = [])
    {
        $this->productIds = $productIds;
        $this->productRepository = app(ProductRepository::class);
        $this->inventorySnapshotRepository = app(InventorySnapshotRepository::class);
    }

    public function handle(): void
    {
        $daysOfHistory = Helpers::setting(Setting::KEY_DAYS_SALES_HISTORY, 90, false);

        // From date to calculate DAC. We want to include today so add one day.
        $fromDate = Helpers::utcStartOfLocalDate(Carbon::now()->addDay()->subDays($daysOfHistory));

//        if ($isAdjustingForOutOfStock = Helpers::setting(
//            Setting::KEY_ADJUST_FORECAST_OUT_OF_STOCK,
//            false,
//            false
//        )) {
//            /*
//             * Check if there are any invalid snapshots, if so, we cannot cache DAC yet and have to run the job to
//             * validate snapshots first.
//             */
////             InventorySnapshot is not currently in use
//                        if ($this->inventorySnapshotRepository->areThereInvalidCaches())
//                        {
//                            dispatch(new InventorySnapshotJob());
//                            return;
//                        };
//        }

        $data = $this->productRepository->getQuantitySoldSinceDate($fromDate, $this->productIds);

        $this->productRepository->bulkSaveDailyAverageConsumption($data);

        $this->productRepository->clearInvalidDailyAverageConsumptionCache($this->productIds);

        /*
         * Disabling the following until it can be optimized to build the data in mysql vs. memory through foreach loop
         * Also, adjusting for out of stock days has questionable utility.  A more sophisticated model would only count
         * days it was available for sale based on sales channel availability, not inventory availability
         */
        // InventorySnapshot is not currently in use

        // Looks at products with invalid cache since from date
        //        $this->productRepository->getQuantitySoldSinceDate($fromDate, $this->productId)
        //            ->each(function ($productSalesData) use ($daysOfHistory, $isAdjustingForOutOfStock) {
        //                // Do we adjust for days out of stock?
        //                if ($isAdjustingForOutOfStock)
        //                {
        //                    $daysInStock = 0;
        //
        //                    // First, answer was this in stock before from date?
        //                    $in_stock =
        //                        $this->inventorySnapshotRepository->wasProductInStockBeforeDate(
        //                            $productSalesData->product_id,
        //                            Helpers::utcStartOfLocalDate(Carbon::now('UTC'))->subDays($daysOfHistory)
        //                        );
        //
        //                    /*
        //                     *  Propagate through snapshots since from date to add each day in stock, interpolating where there
        //                     *  are missing records
        //                     */
        //                    $this->inventorySnapshotRepository->getProductSnapshotsOnOrAfterDate(
        //                        $productSalesData->product_id,
        //                        Helpers::utcStartOfLocalDate(Carbon::now()->subDays($daysOfHistory))
        //                    )->each(function (InventorySnapshot $inventorySnapshot) use (
        //                        &$in_stock,
        //                        &$daysInStock,
        //                        &$snapshotDate,
        //                        $daysOfHistory
        //                    ) {
        //                        $snapshotDate = $snapshotDate ?? Carbon::now()->subDays($daysOfHistory + 1);
        //                        if ($in_stock)
        //                        {
        //                            // interpolate missing days
        //                            $daysInStock += $inventorySnapshot->date->diffInDays($snapshotDate);
        //                        }
        //                        $in_stock = $inventorySnapshot->inventory_in_stock;
        //                        $snapshotDate = $inventorySnapshot->date;
        //                    });
        //                    // interpolate missing days from last snapshot date available to today
        //                    $daysInStock += $in_stock ? Carbon::now()->diffInDays($snapshotDate) : 0;
        //                    $daysOfHistory = $daysInStock;
        //                }
        //                /** @var Product $product */
        //                $product = $this->productRepository->getForIdOrFail($productSalesData->product_id);
        //
        //                $daysOfHistory = max($daysOfHistory, 1);
        //
        //                // Calculate Daily Average Consumption
        //                $product->daily_average_consumption = $productSalesData->quantity / $daysOfHistory;
        //                $product->is_daily_average_consumption_cache_valid = 1;
        //                $product->save();
        //            });
    }
}
