<?php

namespace App\Abstractions;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Arr;

Abstract class JsonObjectFactory extends Factory
{
    public function withJsonObjectOverrides(array $overrides): static
    {
        return $this->state(function (array $attributes) use ($overrides) {
            $jsonObject = Arr::get($attributes, 'json_object', []);

            foreach ($overrides as $key => $value) {
                $jsonObject[$key] = $value;
            }

            return ['json_object' => $jsonObject];
        });
    }
}