<?php

namespace App\Abstractions\Integrations\SalesChannels;

use App\Abstractions\Integrations\IntegrationInstanceInterface;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Collection;

interface SalesChannelOrderRepositoryInterface
{
    public function save(IntegrationInstanceInterface $integrationInstance, Collection $orders): void;

    // TODO: Add saveLines
    // TODO: Add bulkDelete

    public function getStartDateForNew(IntegrationInstanceInterface $integrationInstance): Carbon;

    public function getOrderFromId(IntegrationInstanceInterface $integrationInstance, string $orderId): ?AbstractSalesChannelOrder;

    public function getCanceledOrdersQuery(IntegrationInstanceInterface $integrationInstance, ?Collection $collection = null): Builder;
}
