<?php

namespace App\Abstractions\Integrations\SalesChannels;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Collections\SalesOrderLineCollection;
use App\Data\CustomerData;
use App\Data\FinancialLineData;
use App\DTO\FieldValueMappingDto;
use App\DTO\SalesOrderDto;
use App\DTO\SalesOrderStatusesDto;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

interface SalesChannelOrderInterface
{
    public function integrationInstance(): BelongsTo;

    public function orderItems(): HasMany;

    public function getSalesOrderStatusesDto(): SalesOrderStatusesDto;

    public function getCurrencyCode(?string $salesChannelOrderCurrencyCode = null): string;

    public function getCustomerDto(): ?CustomerData;

    public function getSalesOrderLines(): SalesOrderLineCollection;

    public function getSalesOrderDto(): SalesOrderDto;

    public function getShippingLine(): ?FinancialLineData;

    public function getDiscountLine(): ?FinancialLineData;

    public function getShippingTotal(): float;

    public function getShippingTaxTotal(): float;

    public function manager(IntegrationInstanceInterface $integrationInstance): SalesChannelOrderManagerInterface;

    public function refreshAdt(): ApiDataTransformerInterface;

    public static function repository(): SalesChannelOrderRepositoryInterface;

    public static function getUniqueId(): string;

    public static function getTableUniqueId(): string;

    public static function getLastModified(): string;

    public static function getOrderDate(): string;

    public static function getCurrency(): ?string;

    public function getIsFulfillable(): bool;

    public static function getDateRestrictionExceptionMapping(): ?FieldValueMappingDto;

    public static function newFactory();
}
