<?php

namespace App\Abstractions\Integrations\SalesChannels;

use App\DataTable\NewDataTableResource;

class SalesChannelIntegrationDataTableResource extends NewDataTableResource
{
    public function getCustomColumns(): array
    {
        return [
            'integration_name' => $this->inclusive('integration_name', $this->whenLoaded('integration', function () {
                return $this->resource->integration->name;
            })),
            'store' => $this->inclusive('store', $this->whenLoaded('salesChannel', function () {
                return [
                    'id' => $this->resource->salesChannel->store->id,
                    'name' => $this->resource->salesChannel->store->name,
                ];
            })),
        ];
    }
}