<?php

namespace App\Abstractions\Integrations\SalesChannels;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use App\Abstractions\Integrations\ClientResponseDataInterface;
use App\Abstractions\Integrations\IntegrationClientInterface;
use Illuminate\Support\Collection;

interface SalesChannelClientInterface extends IntegrationClientInterface
{
    public function getOrder(string $orderId): ClientResponseDataInterface;

    public function getOrders(ApiDataTransformerInterface $parameters): ClientResponseDataInterface;

    public function getProduct(string $productId): array;

    public function fulfillOrder(ApiDataTransformerInterface $parameters);

    public function fulfillOrders(ApiDataTransformerInterface $parameters);

    public function syncInventory(ApiDataTransformerInterface $parameters);

    public function getProducts(ApiDataTransformerInterface $parameters): ClientResponseDataInterface;
}
