<?php

namespace App\Abstractions\Integrations\SalesChannels;

use App\Abstractions\Integrations\AbstractIntegrationInstanceRepository;
use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Repositories\SalesChannelRepository;
use Throwable;

abstract class AbstractSalesChannelIntegrationInstanceRepository extends AbstractIntegrationInstanceRepository
{
    /**
     * @throws Throwable
     */
    public function delete(AbstractSalesChannelIntegrationInstance|IntegrationInstanceInterface $integrationInstance): void
    {
        $model = app(static::getIntegrationInstanceClassName());
        $order = app($model::getOrderClass());
        $product = app($model::getProductClass());

        parent::setStatusDeleting($integrationInstance);

        // Delete all orders
        $order->repository()->bulkDelete($integrationInstance->orders->pluck('id')->toArray());

        // Delete all products
        $product->repository()->bulkDelete($integrationInstance->products->pluck('id')->toArray());

        // Delete sales channel
        if ($integrationInstance->salesChannel)
        {
            app(SalesChannelRepository::class)->delete($integrationInstance->salesChannel);
        }

        parent::delete($integrationInstance);
    }
}