<?php

namespace App\Abstractions\Integrations\SalesChannels;

use App\DataTable\DataTable;
use App\Http\Controllers\Controller;
use App\Response;
use Illuminate\Contracts\Queue\ShouldQueue;

abstract class AbstractSalesChannelFinancialEventController extends Controller
{
    use DataTable;

    abstract protected function getModel(): string;

    abstract protected function getResource(): string;

    public function abstractShow(SalesChannelFinancialEventInterface $financialEvent)
    {
        return $this->response->addData($this->getResource()::make($financialEvent));
    }

    public function abstractRefresh(ShouldQueue $refreshJob): Response
    {
        dispatch($refreshJob)->onQueue('sales-channels');

        return $this->response->setMessage('Added to queue, orders will be refreshed shortly.');
    }
}
