<?php

namespace App\Abstractions\Integrations;

use App\Enums\HttpMethodEnum;
use Illuminate\Http\Client\PendingRequest;
use Illuminate\Http\Client\Response;

interface IntegrationClientInterface
{
    public function areCredentialsValid(): bool;

    public function client(): PendingRequest;

    public function setIntegrationInstance(IntegrationInstanceInterface $integrationInstance);

    public function getRedirectUrl(): string;

    public function setBaseUrl(string $baseUrl): void;

    public function getBaseUrl(): string;

    public function setRequestHeaders(IntegrationHeaderDtoInterface $headerDto): void;

    public function getRequestHeaders(): array;

    public function request(HttpMethodEnum $httpMethod, string $path, array $parameters): Response;
}
