<?php

namespace App\Abstractions\Integrations\Accounting;

use App\Abstractions\Integrations\IntegrationInstanceInterface;
use Illuminate\Database\Eloquent\Collection as EloquentCollection;
use Illuminate\Support\Collection;

interface AccountingJournalRepositoryInterface extends AccountingTransactionRepositoryInterface
{
    public function saveForIntegration(IntegrationInstanceInterface $integrationInstance, Collection $transactions): void;

    public function saveAndGetRecordsForIntegration(IntegrationInstanceInterface $integrationInstance, Collection $transactions): EloquentCollection;

    public function getModelClassName(): string;
}
