<?php

namespace App\Abstractions\Integrations\Accounting;

use App\Abstractions\Integrations\IntegrationInstanceInterface;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection as EloquentCollection;
use Illuminate\Support\Collection;

interface AccountingAccountRepositoryInterface
{
    public function saveForIntegration(IntegrationInstanceInterface $integrationInstance, Collection $accounts): void;

    public function getStartDateForNew(IntegrationInstanceInterface $integrationInstance): Carbon;

    public function getAccountsWithoutNominalCodesIn(array $ids): EloquentCollection;
}
