<?php

namespace App\Abstractions\Integrations\Accounting;

use App\Abstractions\Integrations\AbstractIntegrationRepository;
use App\Models\AccountingTransaction;
use App\Repositories\IntegrationInstanceRepository;
use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Database\Query\JoinClause;

abstract class AbstractAccountingTransactionRepository extends AbstractIntegrationRepository
{
    public function getTransactionsNeedingUpdate(array $accounting_transaction_ids, string $accountingLinkType, ?int $limit = 30)
    {
        $accountingTransactionsTable = $this->model->getTable();

        $query = AccountingTransaction::select('accounting_transactions.*')
            ->where('link_type', $accountingLinkType)
            ->where('is_sync_enabled', true)
            ->with('accountingIntegration')
            ->leftJoin($accountingTransactionsTable, function (JoinClause $join) use ($accountingTransactionsTable) {
                $join->on($accountingTransactionsTable.'.id', 'accounting_transactions.accounting_integration_id');
                $join->where('accounting_transactions.accounting_integration_type', get_class($this->model));
            })
            // ->whereNull('accounting_integration_type')
            // ->whereNull('submission_started_at')
            // ->where('is_batchable', false)
            ->where('transaction_date', '>=', app(IntegrationInstanceRepository::class)->getAccountingInstance()->integration_settings['settings']['sync_start_date']);

        if (count($accounting_transaction_ids)) {
            $query->whereIn('accounting_transactions.id', $accounting_transaction_ids);
        } else {
            $query->where(function (Builder $query) use ($accountingTransactionsTable) {
                $query->whereNull('accounting_integration_id');
                $query->orWhereColumn('accounting_transactions.updated_at', '>', $accountingTransactionsTable.'.updated_at');
                $query->orWhereNull($accountingTransactionsTable.'.updated_at');
            });
        }

        if ($limit) {
            $query->limit($limit);
        }

        return $query->orderBy('updated_at', 'asc')->cursor();
    }

    public function linkTransactionWithAccountingTransaction(AccountingTransaction $skuAccountingTransaction, AbstractAccountingModel $accountingTransaction): void
    {
        $skuAccountingTransaction->last_sync_error = null;
        $skuAccountingTransaction->accounting_integration_id = $accountingTransaction->id;
        $skuAccountingTransaction->accounting_integration_type = get_class($accountingTransaction);
        $skuAccountingTransaction->update();
    }
}
