<?php

namespace App\Abstractions\Integrations\Accounting;

use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Abstractions\Integrations\IntegrationModelInterface;
use App\DataTable\DataTableModelInterface;
use App\DataTable\DataTableModelTrait;
use App\Models\IntegrationInstance;
use Awobaz\Compoships\Compoships;
use Awobaz\Compoships\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Model;

/**
 * @property-read IntegrationInstanceInterface $integrationInstance
 */
abstract class AbstractAccountingProduct extends Model implements AccountingAccountInterface, DataTableModelInterface, IntegrationModelInterface
{
    use Compoships;
    use DataTableModelTrait;

    public function integrationInstance(): BelongsTo
    {
        return $this->belongsTo(IntegrationInstance::class);
    }
}
