<?php

namespace App\Abstractions\Integrations\Accounting;

use App\Models\AccountingTransaction;
use App\Models\Supplier;
use App\Repositories\IntegrationInstanceRepository;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection as EloquentCollection;
use Illuminate\Database\Query\JoinClause;

abstract class AbstractAccountingContactRepository implements AccountingContactRepositoryInterface
{
    abstract public function getModelClass(): string;

    public function getSuppliersNeedingUpdate(array $supplier_ids = []) : EloquentCollection
    {
        $accountingContactsTable = app($this->getModelClass())->getTable();
        $query = Supplier::query()
            ->leftJoin($accountingContactsTable, function (JoinClause $join) use ($accountingContactsTable) {
                $join->on($accountingContactsTable . '.link_id', 'suppliers.id');
                $join->where($accountingContactsTable . '.link_type', Supplier::class);
            })
            ->where(function (Builder $query) use ($accountingContactsTable) {
                $query->whereNull($accountingContactsTable . '.link_id');
                $query->orWhereColumn('suppliers.updated_at', '>', $accountingContactsTable . '.updated_at');
                $query->orWhereNull($accountingContactsTable . '.updated_at');

            });
        if ($supplier_ids)
        {
            $query->where(function (Builder $supplierQuery) use ($supplier_ids) {
                $supplierQuery->orWhereIn('suppliers.id', $supplier_ids);
            });
        }

        return $query->get(['suppliers.*']);
    }
}