<?php

namespace App\Abstractions\Integrations\Accounting;

use App\DataTable\DataTable;
use App\Http\Controllers\Controller;
use App\Response;
use Illuminate\Contracts\Queue\ShouldQueue;

abstract class AbstractAccountingAccountController extends Controller
{
    use DataTable;

    abstract protected function getModel(): string;

    abstract protected function getResource(): string;

    public function abstractRefresh(ShouldQueue $refreshJob): Response
    {
        dispatch($refreshJob)->onQueue('sales-channels'); //TODO: connection name

        return $this->response->setMessage('Added to queue, accounts will be refreshed shortly.');
    }
}
