<?php

namespace App\Abstractions\Integrations;

use Exception;

abstract class AbstractIntegrationClient
{
    protected bool $isApiLoggingEnabled = true;

    protected IntegrationInstanceInterface $integrationInstance;

    protected string $redirectUrl;

    protected string $baseUrl;

    protected string $host;

    protected array $requestHeaders;

    public function __construct(IntegrationInstanceInterface $integrationInstance)
    {
        $this->integrationInstance = $integrationInstance;
    }

    public function setBaseUrl(string $baseUrl): void
    {
        $this->host = parse_url($baseUrl)['host'];

        $this->baseUrl = $baseUrl;
    }

    public function getBaseUrl(): string
    {
        return $this->baseUrl;
    }

    public function setRequestHeaders(IntegrationHeaderDtoInterface $headerDto): void
    {
        $this->requestHeaders = $headerDto->toArray();
    }

    public function getRequestHeaders(): array
    {
        return $this->requestHeaders;
    }

    /**
     * @throws Exception
     */
    public function setIntegrationInstance(IntegrationInstanceInterface $integrationInstance): static
    {
        $this->integrationInstance = $integrationInstance;

        return $this;
    }

    public function areCredentialsValid(): bool
    {
        // TODO: Implement in inheritors once we know how to validate
        return true;
    }
}
