<?php

namespace App\Abstractions\Integrations;

use App\Abstractions\Integrations\Data\AbstractJsonObjectData;
use App\Abstractions\Integrations\Data\AbstractSalesChannelData;
use Illuminate\Support\Optional;
use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;

abstract class AbstractClientResponseData extends Data implements ClientResponseDataInterface
{
    public function __construct(
        #[DataCollectionOf(AbstractSalesChannelData::class)]
        public DataCollection $collection,
        public Optional|string|null $nextToken,
    )
    {
    }
}
