<?php

namespace App\Abstractions;

use App\Data\AccountingTransactionData;
use App\Models\AccountingTransaction;
use Illuminate\Database\Eloquent\Builder;

interface FinancialDocumentInterface
{
    public function getAccountingTransactionData(): AccountingTransactionData;

    public function getParentAccountingTransaction(): ?AccountingTransaction;

    public function scopeAccountingReady(Builder $builder): Builder;

    public function getAccountingDateFieldName(): string;
}