<?php

namespace App\Abstractions;

use App\Models\Address;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * @property-read Collection $productLines
 * @property Carbon $asn_last_sent_at
 * @property-read Collection $removalShipments
 */
interface AdvancedShipmentNoticeInterface
{
    public function productLines(): HasMany;

    public function getReferenceNumber(): string;

    public function getDestinationAddress(): Address;

    public function getFromEmail(): string;
}