<?php

namespace App\Abstractions;

use App\Abstractions\Integrations\Data\AuthenticationAuthorizationResponseInterface;
use App\Abstractions\Integrations\Data\OauthAuthenticationAuthorizationResponseInterface;
use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Abstractions\Integrations\OauthAuthenticationClientInterface;
use Exception;

abstract class AbstractOauthAuthenticationCallbackCallbackController extends AbstractAuthenticationCallbackController
{
    /**
     * @throws Exception
     */
    public function abstractCallback(OauthAuthenticationAuthorizationResponseInterface|AuthenticationAuthorizationResponseInterface $data): IntegrationInstanceInterface
    {
        $integrationInstance = $this->getIntegrationInstanceFromState($data->{$this->getStateParameterName()});

        $this->getIntegrationInstanceRepository()->updateConnectionSettings($integrationInstance, $data->getAdditionalInfo());

        /** @var OauthAuthenticationClientInterface $client */
        $client = $this->getClient($integrationInstance);

        $refreshTokenResponse = $client->getRefreshTokenFromAuthCode($data->getAuthCode());

        $this->getIntegrationInstanceRepository()->updateConnectionSettings($integrationInstance, $refreshTokenResponse->toArray());

        return $integrationInstance->refresh();
    }
}
