<?php

// @formatter:off
/**
 * A helper file for your Eloquent Models
 * Copy the phpDocs from this file to the correct Model,
 * And remove them from this file, to prevent double declarations.
 *
 * @author Barry vd. Heuvel <barryvdh@gmail.com>
 */


namespace Modules\Amazon\Entities{
/**
 * Modules\Amazon\Entities\AmazonFbaInboundShipment
 *
 * @property int $id
 * @property int $integration_instance_id
 * @property string $ShipmentId
 * @property string $ShipmentName
 * @property string $ShipFromName
 * @property string $DestinationFulfillmentCenterId
 * @property string $ShipmentStatus
 * @property string $LabelPrepType
 * @property string $BoxContentsSource
 * @property array $json_object
 * @property-read AmazonIntegrationInstance $integrationInstance
 * @property-read Collection|AmazonFbaInboundShipmentItem[] $amazonFbaInboundShipmentItems
 * @property-read WarehouseTransfer|PurchaseOrder $skuLink
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaInboundShipment addCustomColumns()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaInboundShipment addRelations($request = null)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaInboundShipment defaultSort($request = null)
 * @method static \Modules\Amazon\Database\Factories\AmazonFbaInboundShipmentFactory factory(...$parameters)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaInboundShipment filter($request = null)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaInboundShipment filterKey($key, $operator, $value = null, $conjunction = 'and')
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaInboundShipment filterWhereNestedRelation(array $relation, string $operator, $value, $conjunction)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaInboundShipment newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaInboundShipment newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaInboundShipment query()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaInboundShipment sort(?mixed $request = null)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaInboundShipment sortKey($key, $ascending = true)
 */
	class IdeHelperAmazonFbaInboundShipment {}
}

namespace Modules\Amazon\Entities{
/**
 * Modules\Amazon\Entities\AmazonFbaReportCustomerReturn
 *
 * @property int $id
 * @property int $integration_instance_id
 * @property-read string $return_date
 * @property-read string $order_id
 * @property-read string $sku
 * @property-read string $asin
 * @property-read string $fnsku
 * @property-read string $product_name
 * @property-read int $quantity
 * @property-read string $fulfillment_center_id
 * @property-read string $detailed_disposition
 * @property-read string $reason
 * @property-read string $status
 * @property-read string $license_plate_number
 * @property-read string $customer_comments
 * @property array $json_object
 * @property-read AmazonIntegrationInstance $integrationInstance
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 * @property int $amazon_report_id
 * @property-read \Modules\Amazon\Entities\AmazonFbaReportInventoryLedger|null $ledger
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportCustomerReturn addDistinctClause()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportCustomerReturn addSelectClause($includeAllStageColumns = false)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportCustomerReturn addWhereConditionWhileImporting()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportCustomerReturn afterImportHook()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportCustomerReturn beforeImportHook()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportCustomerReturn bulkImportFilter($temporaryTableName, $whereClause)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportCustomerReturn dataFeedBulkImport($args)
 * @method static \Modules\Amazon\Database\Factories\AmazonFbaReportCustomerReturnFactory factory(...$parameters)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportCustomerReturn makeSelectQueryForDataFeed()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportCustomerReturn newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportCustomerReturn newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportCustomerReturn query()
 */
	class IdeHelperAmazonFbaReportCustomerReturn {}
}

namespace Modules\Amazon\Entities{
/**
 * Modules\Amazon\Entities\AmazonFbaReportInventoryLedger
 *
 * @property int $id
 * @property int $integration_instance_id
 * @property int $amazon_product_id
 * @property int $sku_link_id
 * @property string $sku_link_type
 * @property int $detail_id
 * @property string $detail_type
 * @property-read string $date
 * @property-read string $fnsku
 * @property-read string $asin
 * @property-read string $msku
 * @property-read string $title
 * @property-read FbaInventoryLedgerReportEventTypeEnum $event_type
 * @property-read string $reference_id
 * @property-read string $quantity
 * @property-read string $fulfillment_center
 * @property-read float $disposition
 * @property-read float $reason
 * @property-read int $country
 * @property-read int $reconciled_quantity
 * @property-read int $unreconciled_quantity
 * @property array $json_object
 * @property-read AmazonIntegrationInstance $integrationInstance
 * @property-read AmazonProduct $amazonProduct
 * @property-read AbstractAmazonFbaDetailReport $detail
 * @property-read InventoryEvent $skuLink
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 * @property int $amazon_report_id
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportInventoryLedger addCustomColumns()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportInventoryLedger addDistinctClause()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportInventoryLedger addRelations($request = null)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportInventoryLedger addSelectClause($includeAllStageColumns = false)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportInventoryLedger addWhereConditionWhileImporting()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportInventoryLedger afterImportHook()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportInventoryLedger beforeImportHook()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportInventoryLedger bulkImportFilter($temporaryTableName, $whereClause)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportInventoryLedger dataFeedBulkImport($args)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportInventoryLedger defaultSort($request = null)
 * @method static \Modules\Amazon\Database\Factories\AmazonFbaReportInventoryLedgerFactory factory(...$parameters)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportInventoryLedger filter($request = null)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportInventoryLedger filterKey($key, $operator, $value = null, $conjunction = 'and')
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportInventoryLedger filterWhereNestedRelation(array $relation, string $operator, $value, $conjunction)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportInventoryLedger makeSelectQueryForDataFeed()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportInventoryLedger newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportInventoryLedger newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportInventoryLedger query()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportInventoryLedger sort(?mixed $request = null)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportInventoryLedger sortKey($key, $ascending = true)
 */
	class IdeHelperAmazonFbaReportInventoryLedger {}
}

namespace Modules\Amazon\Entities{
/**
 * Modules\Amazon\Entities\AmazonFbaReportRemovalShipment
 *
 * @property int $id
 * @property int $integration_instance_id
 * @property-read string $request_date
 * @property-read string $order_id
 * @property-read string $shipment_date
 * @property-read string $sku
 * @property-read string $fnsku
 * @property-read string $disposition
 * @property-read int $shipped_quantity
 * @property-read string $carrier
 * @property-read string $tracking_number
 * @property-read string $removal_order_type
 * @property array $json_object
 * @property-read AmazonIntegrationInstance $integrationInstance
 * @property-read AmazonFbaReportRemovalOrder $amazonFbaReportRemovalOrder
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 * @property int $amazon_report_id
 * @property-read \Modules\Amazon\Entities\AmazonFbaReportInventoryLedger|null $ledger
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportRemovalShipment addDistinctClause()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportRemovalShipment addSelectClause($includeAllStageColumns = false)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportRemovalShipment addWhereConditionWhileImporting()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportRemovalShipment afterImportHook()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportRemovalShipment beforeImportHook()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportRemovalShipment bulkImportFilter($temporaryTableName, $whereClause)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportRemovalShipment dataFeedBulkImport($args)
 * @method static \Modules\Amazon\Database\Factories\AmazonFbaReportRemovalShipmentFactory factory(...$parameters)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportRemovalShipment makeSelectQueryForDataFeed()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportRemovalShipment newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportRemovalShipment newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportRemovalShipment query()
 */
	class IdeHelperAmazonFbaReportRemovalShipment {}
}

namespace Modules\Amazon\Entities{
/**
 * Modules\Amazon\Entities\AmazonFbaReportRestock
 *
 * @property int $id
 * @property int $integration_instance_id
 * @property-read string $country
 * @property-read string $product_name
 * @property-read string $fnsku
 * @property-read string $merchant_sku
 * @property-read string $asin
 * @property-read string $condition
 * @property-read string $supplier
 * @property-read string $supplier_part_no
 * @property-read string $currency_code
 * @property-read float $price
 * @property-read float $sales_last_30_days
 * @property-read int $units_sold_last_30_days
 * @property-read int $total_units
 * @property-read int $inbound
 * @property-read int $available
 * @property-read int $fc_transfer
 * @property-read int $fc_processing
 * @property-read int $customer_order
 * @property-read int $unfulfillable
 * @property-read int $working
 * @property-read int $shipped
 * @property-read int $receiving
 * @property-read string $fulfilled_by
 * @property-read string $total_days_of_supply
 * @property-read string $days_of_supply_at_amazon_fulfillment_network
 * @property-read string $alert
 * @property-read int $recommended_replenishment_qty
 * @property-read string $recommended_ship_date
 * @property array $json_object
 * @property-read AmazonIntegrationInstance $integrationInstance
 * @property Carbon $created_at
 * @property null|Carbon $updated_at
 * @property int $amazon_report_id
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportRestock addDistinctClause()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportRestock addSelectClause($includeAllStageColumns = false)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportRestock addWhereConditionWhileImporting()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportRestock afterImportHook()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportRestock beforeImportHook()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportRestock bulkImportFilter($temporaryTableName, $whereClause)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportRestock dataFeedBulkImport($args)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportRestock makeSelectQueryForDataFeed()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportRestock newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportRestock newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportRestock query()
 */
	class IdeHelperAmazonFbaReportRestock {}
}

namespace Modules\Amazon\Entities{
/**
 * Modules\Amazon\Entities\AmazonFbaReportShipment
 *
 * @property int $id
 * @property int $integration_instance_id
 * @property-read string $amazon_order_id
 * @property-read string $merchant_order_id
 * @property-read string $shipment_id
 * @property-read string $shipment_item_id
 * @property-read string $amazon_order_item_id
 * @property-read string $merchant_order_item_id
 * @property-read string $purchase_date
 * @property-read string $payments_date
 * @property-read string $shipment_date
 * @property-read string $reporting_date
 * @property-read string $buyer_name
 * @property-read string $buyer_phone_number
 * @property-read string $sku
 * @property-read string $product_name
 * @property-read int $quantity_shipped
 * @property-read string $currency
 * @property-read float $item_price
 * @property-read float $item_tax
 * @property-read float $shipping_price
 * @property-read float $shipping_tax
 * @property-read float $gift_wrap_price
 * @property-read float $gift_wrap_tax
 * @property-read string $ship_service_level
 * @property-read string $recipient_name
 * @property-read string $ship_address1
 * @property-read string $ship_address2
 * @property-read string $ship_address3
 * @property-read string $ship_city
 * @property-read string $ship_state
 * @property-read string $ship_postal_code
 * @property-read string $ship_country
 * @property-read string $ship_phone_number
 * @property-read string $bill_address1
 * @property-read string $bill_address2
 * @property-read string $bill_address3
 * @property-read string $bill_city
 * @property-read string $bill_state
 * @property-read string $bill_postal_code
 * @property-read string $bill_country
 * @property-read float $item_promotion_discount
 * @property-read float $ship_promotion_discount
 * @property-read string $carrier
 * @property-read string $tracking_number
 * @property-read string $estimated_arrival_date
 * @property-read string $fulfillment_center_id
 * @property-read string $fulfillment_channel
 * @property-read string $sales_channel
 * @property array $json_object
 * @property-read AmazonIntegrationInstance $integrationInstance
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 * @property int $amazon_report_id
 * @property string|null $ship_address_1
 * @property string|null $ship_address_2
 * @property string|null $ship_address_3
 * @property string|null $bill_address_1
 * @property string|null $bill_address_2
 * @property string|null $bill_address_3
 * @property-read \Modules\Amazon\Entities\AmazonFbaReportInventoryLedger|null $ledger
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportShipment addDistinctClause()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportShipment addSelectClause($includeAllStageColumns = false)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportShipment addWhereConditionWhileImporting()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportShipment afterImportHook()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportShipment beforeImportHook()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportShipment bulkImportFilter($temporaryTableName, $whereClause)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportShipment dataFeedBulkImport($args)
 * @method static \Modules\Amazon\Database\Factories\AmazonFbaReportShipmentFactory factory(...$parameters)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportShipment makeSelectQueryForDataFeed()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportShipment newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportShipment newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFbaReportShipment query()
 */
	class IdeHelperAmazonFbaReportShipment {}
}

namespace Modules\Amazon\Entities{
/**
 * Class AmazonFeed.
 *
 * @property int $id
 * @property string $feedType
 * @property array $marketplaceIds
 * @property array $feedOptions
 * @property-read AmazonIntegrationInstance $integrationInstance
 * @property int $integration_instance_id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFeedRequest newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFeedRequest newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFeedRequest query()
 */
	class IdeHelperAmazonFeedRequest {}
}

namespace Modules\Amazon\Entities{
/**
 * Class AmazonFeed.
 *
 * @property int $id
 * @property string $feedId
 * @property string $feedType
 * @property array $marketplaceIds
 * @property string $inputFeedDocumentId
 * @property array $feedOptions
 * @property string $createdTime
 * @property string $processingStatus
 * @property string $processingStartTime
 * @property string $processingEndTime
 * @property string $resultFeedDocumentId
 * @property string $url
 * @property string $compressionAlgorithm
 * @property string $filename
 * @property-read AmazonIntegrationInstance $integrationInstance
 * @property int $integration_instance_id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFeedSubmission newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFeedSubmission newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFeedSubmission query()
 */
	class IdeHelperAmazonFeedSubmission {}
}

namespace Modules\Amazon\Entities{
/**
 * Modules\Amazon\Entities\AmazonFinancialEvent
 *
 * @property-read \Modules\Amazon\Entities\AmazonIntegrationInstance $integrationInstance
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFinancialEvent newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFinancialEvent newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFinancialEvent query()
 */
	class IdeHelperAmazonFinancialEvent {}
}

namespace Modules\Amazon\Entities{
/**
 * Modules\Amazon\Entities\AmazonFinancialEventGroup
 *
 * @property int $integration_instance_id
 * @property-read string $FinancialEventGroupId
 * @property-read string $ProcessingStatus
 * @property-read string $FundTransferStatus
 * @property-read string $OriginalTotalCurrencyCode
 * @property-read float $OriginalTotalCurrencyAmount
 * @property-read string $ConvertedTotalCurrencyCode
 * @property-read float $ConvertedTotalCurrencyAmount
 * @property-read string $FundTransferDate
 * @property-read string $TraceId
 * @property-read string $AccountTail
 * @property-read string $BeginningBalanceCurrencyCode
 * @property-read float $BeginningBalanceCurrencyAmount
 * @property-read string $FinancialEventGroupStart
 * @property-read string $FinancialEventGroupEnd
 * @property array $json_object
 * @property-read AmazonIntegrationInstance $integrationInstance
 * @property Carbon $created_at
 * @property null|Carbon $updated_at
 * @property int $id
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFinancialEventGroup addDistinctClause()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFinancialEventGroup addSelectClause($includeAllStageColumns = false)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFinancialEventGroup addWhereConditionWhileImporting()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFinancialEventGroup afterImportHook()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFinancialEventGroup beforeImportHook()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFinancialEventGroup bulkImportFilter($temporaryTableName, $whereClause)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFinancialEventGroup dataFeedBulkImport($args)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFinancialEventGroup makeSelectQueryForDataFeed()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFinancialEventGroup newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFinancialEventGroup newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFinancialEventGroup query()
 */
	class IdeHelperAmazonFinancialEventGroup {}
}

namespace Modules\Amazon\Entities{
/**
 * Modules\Amazon\Entities\AmazonFulfillmentOrder
 *
 * @property int $id
 * @property int $integration_instance_id
 * @property string $sellerFulfillmentOrderId
 * @property string $marketplaceId
 * @property string $displayableOrderId
 * @property string $displayableOrderDate
 * @property string $displayableOrderComment
 * @property string $shippingSpeedCategory
 * @property string $deliveryWindow
 * @property array $destinationAddress
 * @property string $fulfillmentAction
 * @property string $fulfillmentPolicy
 * @property array $codSettings
 * @property-read string $receivedDate
 * @property-read string $fulfillmentOrderStatus
 * @property-read string $statusUpdatedDate
 * @property array $notificationEmails
 * @property array $featureConstraints
 * @property array $json_object
 * @property-read AmazonIntegrationInstance $integrationInstance
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection|\Modules\Amazon\Entities\AmazonFulfillmentOrderItem[] $amazonFulfillmentOrderItems
 * @property-read \Illuminate\Database\Eloquent\Collection|\Modules\Amazon\Entities\AmazonFulfillmentReturnAuthorization[] $amazonFulfillmentReturnAuthorizations
 * @property-read \Illuminate\Database\Eloquent\Collection|\Modules\Amazon\Entities\AmazonFulfillmentShipment[] $amazonFulfillmentShipments
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFulfillmentOrder newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFulfillmentOrder newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFulfillmentOrder query()
 */
	class IdeHelperAmazonFulfillmentOrder {}
}

namespace Modules\Amazon\Entities{
/**
 * Modules\Amazon\Entities\AmazonFulfillmentOrderItem
 *
 * @property int $id
 * @property int $amazon_fulfillment_order_id
 * @property string $sellerSku
 * @property string $sellerFulfillmentOrderItemId
 * @property int $quantity
 * @property string $giftMessage
 * @property string $displayableComment
 * @property string $fulfillmentNetworkSku
 * @property-read string $orderItemDisposition
 * @property-read int $cancelledQuantity
 * @property-read int $unfulfillableQuantity
 * @property-read string $estimatedShipDate
 * @property-read string $estimatedArrivalDate
 * @property string $perUnitPriceCurrencyCode
 * @property float $perUnitPriceCurrencyValue
 * @property string $perUnitTaxCurrencyCode
 * @property float $perUnitTaxValue
 * @property string $perUnitDeclaredValueCurrencyCode
 * @property float $perUnitDeclaredValueValue
 * @property array $json_object
 * @property-read AmazonFulfillmentOrder $amazonFulfillmentOrder
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFulfillmentOrderItem newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFulfillmentOrderItem newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFulfillmentOrderItem query()
 */
	class IdeHelperAmazonFulfillmentOrderItem {}
}

namespace Modules\Amazon\Entities{
/**
 * Modules\Amazon\Entities\AmazonFulfillmentReturnAuthorization
 *
 * @property int $id
 * @property int $amazon_fulfillment_order_id
 * @property-read string $returnAuthorizationId
 * @property-read string $fulfillmentCenterId
 * @property-read array $returnToAddress
 * @property-read string $amazonRmaId
 * @property-read string $rmaPageURL
 * @property array $json_object
 * @property-read AmazonFulfillmentOrder $amazonFulfillmentOrder
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFulfillmentReturnAuthorization newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFulfillmentReturnAuthorization newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFulfillmentReturnAuthorization query()
 */
	class IdeHelperAmazonFulfillmentReturnAuthorization {}
}

namespace Modules\Amazon\Entities{
/**
 * Modules\Amazon\Entities\AmazonFulfillmentReturnItem
 *
 * @property int $id
 * @property int $amazon_fulfillment_shipment_item_id
 * @property-read string $sellerReturnId
 * @property-read string $sellerFulfillmentOrderItemId
 * @property-read string $amazonShipmentId
 * @property-read string $sellerReturnReasonCode
 * @property-read string $returnComment
 * @property-read string $amazonReturnReasonCode
 * @property-read string $status
 * @property-read string $statusChangedDate
 * @property-read string $returnAuthorizationId
 * @property-read string $returnReceivedCondition
 * @property-read string $fulfillmentCenterId
 * @property array $json_object
 * @property-read AmazonFulfillmentShipmentItem $amazonFulfillmentShipmentItem
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFulfillmentReturnItem newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFulfillmentReturnItem newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFulfillmentReturnItem query()
 */
	class IdeHelperAmazonFulfillmentReturnItem {}
}

namespace Modules\Amazon\Entities{
/**
 * Modules\Amazon\Entities\AmazonFulfillmentShipment
 *
 * @property int $id
 * @property int $amazon_fulfillment_order_id
 * @property-read string $amazonShipmentId
 * @property-read string $fulfillmentCenterId
 * @property-read string $fulfillmentShipmentStatus
 * @property-read string $shippingDate
 * @property-read string $estimatedArrivalDate
 * @property-read string $shippingNotes
 * @property array $json_object
 * @property-read AmazonFulfillmentOrder $amazonFulfillmentOrder
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection|\Modules\Amazon\Entities\AmazonFulfillmentShipmentItem[] $amazonFulfillmentShipmentItems
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFulfillmentShipment newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFulfillmentShipment newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFulfillmentShipment query()
 */
	class IdeHelperAmazonFulfillmentShipment {}
}

namespace Modules\Amazon\Entities{
/**
 * Modules\Amazon\Entities\AmazonFulfillmentShipmentItem
 *
 * @property int $id
 * @property int $amazon_fulfillment_shipment_id
 * @property-read string $sellerSku
 * @property-read string $sellerFulfillmentOrderItemId
 * @property-read int $quantity
 * @property-read int $packageNumber
 * @property-read string $serialNumber
 * @property array $json_object
 * @property-read AmazonFulfillmentShipment $amazonFulfillmentShipment
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection|\Modules\Amazon\Entities\AmazonFulfillmentReturnItem[] $amazonFulfillmentReturnItems
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFulfillmentShipmentItem newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFulfillmentShipmentItem newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFulfillmentShipmentItem query()
 */
	class IdeHelperAmazonFulfillmentShipmentItem {}
}

namespace Modules\Amazon\Entities{
/**
 * Modules\Amazon\Entities\AmazonFulfillmentShipmentPackage
 *
 * @property int $id
 * @property int $amazon_fulfillment_shipment_id
 * @property-read int $packageNumber
 * @property-read string $carrierCode
 * @property-read string $trackingNumber
 * @property-read string $estimatedArrivalDate
 * @property array $json_object
 * @property-read AmazonFulfillmentShipment $amazonFulfillmentShipment
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFulfillmentShipmentPackage newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFulfillmentShipmentPackage newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonFulfillmentShipmentPackage query()
 */
	class IdeHelperAmazonFulfillmentShipmentPackage {}
}

namespace Modules\Amazon\Entities{
/**
 * Modules\Amazon\Entities\AmazonIntegrationInstance
 *
 * @property-read AmazonRegionEnum $region
 * @property-read DataImportMapping $dataImportMapping
 * @property int $id
 * @property int $integration_id
 * @property string $name
 * @property array $connection_settings
 * @property array $integration_settings
 * @property string|null $connection_status
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\ApiLog[] $apiLogs
 * @property-read \Illuminate\Database\Eloquent\Collection|\Modules\Amazon\Entities\AmazonFbaReportInventory[] $fbaInventory
 * @property-read \Illuminate\Database\Eloquent\Collection|\Modules\Amazon\Entities\AmazonFbaReportCustomerReturn[] $fbaReportCustomerReturns
 * @property-read \Illuminate\Database\Eloquent\Collection|\Modules\Amazon\Entities\AmazonFbaReportInventoryLedger[] $fbaReportInventoryLedgers
 * @property-read \Illuminate\Database\Eloquent\Collection|\Modules\Amazon\Entities\AmazonFbaReportRemovalOrder[] $fbaReportRemovalOrders
 * @property-read \Illuminate\Database\Eloquent\Collection|\Modules\Amazon\Entities\AmazonFbaReportRemovalShipment[] $fbaReportRemovalShipments
 * @property-read \Illuminate\Database\Eloquent\Collection|\Modules\Amazon\Entities\AmazonFbaReportRestock[] $fbaReportRestocks
 * @property-read \Illuminate\Database\Eloquent\Collection|\Modules\Amazon\Entities\AmazonFbaReportShipment[] $fbaReportShipments
 * @property-read \Illuminate\Database\Eloquent\Collection|\Modules\Amazon\Entities\AmazonFinancialEventGroup[] $financialEventGroups
 * @property-read \Illuminate\Database\Eloquent\Collection|\Modules\Amazon\Entities\AmazonFulfillmentOrder[] $fulfillmentOrders
 * @property-read mixed $audit_trail_start_date
 * @property-read mixed $closed_start_date
 * @property-read mixed $credentials
 * @property-read array $magento_mappings
 * @property-read mixed $open_start_date
 * @property-read mixed $order_start_date
 * @property-read mixed $payment_type_id
 * @property-read \Illuminate\Database\Eloquent\Collection|\Modules\Amazon\Entities\AmazonFbaInboundShipment[] $inboundShipments
 * @property-read \App\Models\Integration $integration
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\IntegrationInstanceServiceDisruptions[] $integrationInstanceServiceDisruptions
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\IntegrationShippingMethod[] $integrationShippingMethods
 * @property-read \Illuminate\Database\Eloquent\Collection|\Modules\Amazon\Entities\AmazonOrder[] $orders
 * @property-read \Illuminate\Database\Eloquent\Collection|\Modules\Amazon\Entities\AmazonProduct[] $products
 * @property-read \Illuminate\Database\Eloquent\Collection|\Modules\Amazon\Entities\AmazonReportRequest[] $reportRequests
 * @property-read \Illuminate\Database\Eloquent\Collection|\Modules\Amazon\Entities\AmazonReport[] $reports
 * @property-read \App\Models\SalesChannel|null $salesChannel
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\ShippingMethodMappingsSkuToShippingProviderMethod[] $shippingProviderShippingMethodMappings
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\StoreMapping[] $storeMappings
 * @property-read \App\Models\Warehouse|null $warehouse
 * @method static \Illuminate\Database\Eloquent\Builder|IntegrationInstance addCustomColumns()
 * @method static \Illuminate\Database\Eloquent\Builder|IntegrationInstance addRelations($request = null)
 * @method static \Illuminate\Database\Eloquent\Builder|IntegrationInstance amazon()
 * @method static \Modules\Amazon\Database\Factories\AmazonIntegrationInstanceFactory factory(...$parameters)
 * @method static \Illuminate\Database\Eloquent\Builder|IntegrationInstance filter($request = null)
 * @method static \Illuminate\Database\Eloquent\Builder|IntegrationInstance filterKey($key, $operator, $value = null, $conjunction = 'and')
 * @method static \Illuminate\Database\Eloquent\Builder|IntegrationInstance filterWhereNestedRelation(array $relation, string $operator, $value, $conjunction)
 * @method static \Illuminate\Database\Eloquent\Builder|IntegrationInstance magento()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonIntegrationInstance newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonIntegrationInstance newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonIntegrationInstance query()
 * @method static \Illuminate\Database\Eloquent\Builder|IntegrationInstance shipstation()
 * @method static \Illuminate\Database\Eloquent\Builder|IntegrationInstance shopify()
 * @method static \Illuminate\Database\Eloquent\Builder|IntegrationInstance starshipit()
 */
	class IdeHelperAmazonIntegrationInstance {}
}

namespace Modules\Amazon\Entities{
/**
 * Class AmazonOrder.
 *
 * @property int $id
 * @property array $json_object
 * @property int $integration_instance_id
 * @property-read string $AmazonOrderId
 * @property-read string $SellerOrderId
 * @property-read string $PurchaseDate
 * @property-read Carbon $LastUpdateDate
 * @property-read string $OrderStatus
 * @property-read string $FulfillmentChannel
 * @property-read string $SalesChannel
 * @property-read string $ShipServiceLevel
 * @property-read string $OrderCurrency
 * @property-read float $OrderTotal
 * @property-read int $NumberOfItemsShipped
 * @property-read int $NumberOfItemsUnshipped
 * @property-read string $PaymentMethod
 * @property-read string $MarketplaceId
 * @property-read string $ShipmentServiceLevelCategory
 * @property-read string $BuyerName
 * @property-read string $BuyerEmail
 * @property-read string $Name // new
 * @property-read string $AddressLine1 // new
 * @property-read string $AddressLine2 // new
 * @property-read string $City // new
 * @property-read string $StateOrRegion // new
 * @property-read string $PostalCode // new
 * @property-read string $CountryCode // new
 * @property-read string $Phone // new
 * @property-read string $OrderType
 * @property-read string $EarliestShipDate
 * @property-read string $LatestShipDate
 * @property-read string $EarliestDeliveryDate
 * @property-read string $LatestDeliveryDate
 * @property-read string $IsPrime
 * @property-read string $ReplaceOrderId
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property-read AmazonIntegrationInstance $integrationInstance
 * @property-read Collection|AmazonOrderItem[] $amazonOrderItems
 * @property string|null $PaymentMethodDetails
 * @property string|null $IsBusinessOrder
 * @property string|null $IsPremiumOrder
 * @property string|null $ReplacedOrderId
 * @property string|null $IsReplacementOrder
 * @property array|null $errors
 * @property \Illuminate\Support\Carbon|null $archived_at
 * @property \Illuminate\Support\Carbon|null $canceled_at
 * @property mixed $ShippingAddress
 * @property mixed $BuyerInfo
 * @property-read \Modules\Amazon\Entities\AmazonIntegrationInstance $amazonIntegrationInstance
 * @property-read \App\Models\SalesOrder|null $salesOrder
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonOrder addDistinctClause()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonOrder addSelectClause($includeAllStageColumns = false)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonOrder addWhereConditionWhileImporting()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonOrder afterImportHook()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonOrder beforeImportHook()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonOrder bulkImportFilter($temporaryTableName, $whereClause)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonOrder dataFeedBulkImport($args)
 * @method static \Modules\Amazon\Database\Factories\AmazonOrderFactory factory(...$parameters)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonOrder makeSelectQueryForDataFeed()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonOrder newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonOrder newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonOrder query()
 */
	class IdeHelperAmazonOrder {}
}

namespace Modules\Amazon\Entities{
/**
 * Modules\Amazon\Entities\AmazonProduct
 *
 * @property int $id
 * @property int $integration_instance_id
 * @property string $item_name
 * @property string $seller_sku
 * @property float $price
 * @property int $quantity
 * @property string $image_url
 * @property int $product_id_Type
 * @property string $item_note
 * @property int $item_condition
 * @property string $asin1
 * @property int $product_id
 * @property string $fulfillment_channel
 * @property string $merchant_shipping_group
 * @property string $status
 * @property array $json_object
 * @property array $catalog_data
 * @property string $brand
 * @property string $manufacturer
 * @property string $model
 * @property string $part_number
 * @property string $product_type
 * @property string $sales_rank
 * @property string $color
 * @property string $package_length
 * @property string $package_width
 * @property string $package_height
 * @property string $package_dimensions_unit
 * @property string $package_weight
 * @property string $package_weight_unit
 * @property string $main_image
 * @property string $browse_classification
 * @property string $website_group_name
 * @property Carbon $created_at
 * @property Carbon|null $updated_at
 * @property-read ProductListing $productListing
 * @property-read AmazonIntegrationInstance $integrationInstance
 * @property string|null $product_id_type
 * @property \Illuminate\Support\Carbon|null $catalog_data_last_sync
 * @property bool $was_catalog_data_sync_attempted
 * @property-read \Modules\Amazon\Entities\AmazonIntegrationInstance $amazonIntegrationInstance
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct addCustomColumns()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct addDistinctClause()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct addRelations($request = null)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct addSelectClause($includeAllStageColumns = false)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct addWhereConditionWhileImporting()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct afterImportHook()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct beforeImportHook()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct bulkImportFilter($temporaryTableName, $whereClause)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct dataFeedBulkImport($args)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct defaultSort($request = null)
 * @method static \Modules\Amazon\Database\Factories\AmazonProductFactory factory(...$parameters)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct filter($request = null)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct filterKey($key, $operator, $value = null, $conjunction = 'and')
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct filterWhereNestedRelation(array $relation, string $operator, $value, $conjunction)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct hasNestedUsingJoins($relations, $operator = '>=', $count = 1, $boolean = 'and', ?\Closure $callback = null)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct joinNestedRelationship(string $relationships, $callback = null, $joinType = 'join', $useAlias = false, bool $disableExtraConditions = false)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct joinRelation($relationName, $callback = null, $joinType = 'join', $useAlias = false, bool $disableExtraConditions = false)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct joinRelationship($relationName, $callback = null, $joinType = 'join', $useAlias = false, bool $disableExtraConditions = false)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct joinRelationshipUsingAlias($relationName, $callback = null, bool $disableExtraConditions = false)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct leftJoinRelation($relation, $callback = null, $useAlias = false, bool $disableExtraConditions = false)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct leftJoinRelationship($relation, $callback = null, $useAlias = false, bool $disableExtraConditions = false)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct leftJoinRelationshipUsingAlias($relationName, $callback = null, bool $disableExtraConditions = false)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct makeSelectQueryForDataFeed()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct orderByLeftPowerJoins($sort, $direction = 'asc')
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct orderByLeftPowerJoinsAvg($sort, $direction = 'asc')
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct orderByLeftPowerJoinsCount($sort, $direction = 'asc')
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct orderByLeftPowerJoinsMax($sort, $direction = 'asc')
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct orderByLeftPowerJoinsMin($sort, $direction = 'asc')
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct orderByLeftPowerJoinsSum($sort, $direction = 'asc')
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct orderByPowerJoins($sort, $direction = 'asc', $aggregation = null, $joinType = 'join')
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct orderByPowerJoinsAvg($sort, $direction = 'asc')
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct orderByPowerJoinsCount($sort, $direction = 'asc')
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct orderByPowerJoinsMax($sort, $direction = 'asc')
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct orderByPowerJoinsMin($sort, $direction = 'asc')
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct orderByPowerJoinsSum($sort, $direction = 'asc')
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct powerJoinDoesntHave($relation, $boolean = 'and', ?\Closure $callback = null)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct powerJoinHas($relation, $operator = '>=', $count = 1, $boolean = 'and', $callback = null)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct powerJoinWhereHas($relation, $callback = null, $operator = '>=', $count = 1)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct query()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct rightJoinRelation($relation, $callback = null, $useAlias = false, bool $disableExtraConditions = false)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct rightJoinRelationship($relation, $callback = null, $useAlias = false, bool $disableExtraConditions = false)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct rightJoinRelationshipUsingAlias($relationName, $callback = null, bool $disableExtraConditions = false)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct sort(?mixed $request = null)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonProduct sortKey($key, $ascending = true)
 */
	class IdeHelperAmazonProduct {}
}

namespace Modules\Amazon\Entities{
/**
 * Class AmazonReport.
 *
 * @property int $id
 * @property int $integration_instance_id
 * @property string $reportId
 * @property ReportTypeEnum $reportType
 * @property Carbon $dataStartTime
 * @property Carbon $dataEndTime
 * @property array $options
 * @property string $reportScheduledId
 * @property Carbon $createdTime
 * @property string $processingStatus
 * @property Carbon $processingStartTime
 * @property Carbon $processingEndTime
 * @property array $marketplaceIds
 * @property string $reportDocumentId
 * @property string $filename
 * @property-read AmazonIntegrationInstance $integrationInstance
 * @property Carbon $created_at
 * @property Carbon $updated_at
 * @method static amazonReports()
 * @property \Modules\Amazon\Enums\Entities\ReportProcessingStatusEnum $processing_status
 * @method static \Modules\Amazon\Database\Factories\AmazonReportFactory factory(...$parameters)
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonReport newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonReport newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonReport query()
 */
	class IdeHelperAmazonReport {}
}

namespace Modules\Amazon\Entities{
/**
 * Class AmazonReportRequest.
 *
 * @property int $id
 * @property int $integration_instance_id
 * @property ReportTypeEnum $reportType
 * @property Carbon $dataStartTime
 * @property Carbon $dataEndTime
 * @property array $options
 * @property-read AmazonIntegrationInstance $integrationInstance
 * @property Carbon $created_at
 * @property Carbon $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonReportRequest newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonReportRequest newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AmazonReportRequest query()
 */
	class IdeHelperAmazonReportRequest {}
}

