<?php

/** @noinspection PhpArrayShapeAttributeCanBeAddedInspection */

namespace Modules\Xero\Transformers;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Modules\Xero\Entities\XeroTaxRate;

/**
 * @mixin XeroTaxRate
 */
class XeroTaxRateResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  Request
     */
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'Name' => $this->Name,
            'TaxType' => $this->TaxType,
            'EffectiveRate' => $this->EffectiveRate,
        ];
    }
}
