<?php

namespace Modules\Xero\Tests\Feature;

use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Testing\Fluent\AssertableJson;
use Modules\Xero\Entities\XeroTaxRate;
use Modules\Xero\Tests\XeroTest;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;

class XeroTaxRateControllerTest extends XeroTest
{
    use FastRefreshDatabase;
    use WithFaker;

    public function test_it_can_download_tax_rates()
    {

        $this->mockConnectionRequests();
        $this->mockEndpoint(
            endpoint: '/TaxRates?*',
            response: [
                'TaxRates' => [
                    ['Name' => $this->faker->unique()->word()],
                ],
            ]
        );

        $this->postJson('/api/xero/tax-rates/download')->assertSuccessful();
        $this->assertDatabaseCount('xero_tax_rates', 1);
    }

    public function test_it_can_get_xero_accounts()
    {
        XeroTaxRate::factory(5)->create();

        $response = $this->getJson('/api/xero/tax-rates');
        $response->assertSuccessful();

        $response->assertJson(fn (AssertableJson $json) => $json->has('data.0.TaxType')->etc());

        $response->assertJsonCount(5, 'data');
    }
}
