<?php

namespace Modules\Xero\Tests\Feature;

use App\Models\NominalCode;
use Illuminate\Database\Eloquent\Factories\Sequence;
use Illuminate\Testing\Fluent\AssertableJson;
use Modules\Xero\Entities\XeroAccount;
use Modules\Xero\Tests\XeroTest;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;

class XeroAccountControllerTest extends XeroTest
{
    use FastRefreshDatabase;

    public function test_it_can_create_nominal_codes_from_xero_accounts()
    {

        $this->withoutExceptionHandling();

        // Clear existing nominal codes. This ensures that they don't interfere with
        // the test results.
        NominalCode::query()->delete();

        $accounts = XeroAccount::factory(3)
            ->state(new Sequence(
                [
                    'json_object' => json_encode([
                        'Code' => 4000,
                        'Type' => XeroAccount::TYPE_SALES,
                        'Class' => XeroAccount::TYPE_REVENUE,
                        'Name' => 'Sales',
                    ]),
                ],
                [
                    'json_object' => json_encode([
                        'Code' => 3000,
                        'Type' => XeroAccount::TYPE_EQUITY,
                        'Class' => XeroAccount::TYPE_REVENUE,
                        'Name' => 'Owner Capital',
                    ]),
                ],
                [
                    'json_object' => json_encode([
                        'Code' => 160,
                        'Type' => XeroAccount::TYPE_BANK,
                        'Class' => 'ASSET',
                        'Name' => 'Bank of A_10/1',
                    ]),
                ]
            ))
            ->create();

        $ids = $accounts->pluck('id')->toArray();

        $this->postJson('/api/xero/accounts/create-nominal-codes', ['ids' => $ids])->assertSuccessful();
        $this->assertDatabaseCount('nominal_codes', 3);

    }

    public function test_it_can_download_xero_accounts()
    {

        $this->withoutExceptionHandling();
        // Fake the api calls and provide mock responses
        $this->mockConnectionRequests();
        $this->mockEndpoint(
            endpoint: '/Accounts?*',
            response: [
                'Accounts' => [
                    XeroAccount::factory()->make(),
                ],
            ]
        );

        $response = $this->postJson('/api/xero/accounts/download');
        $response->assertSuccessful();
        $this->assertDatabaseCount('xero_accounts', 1);
    }

    public function test_it_can_get_xero_accounts()
    {
        XeroAccount::factory(5)->create();

        $response = $this->getJson('/api/xero/accounts');
        $response->assertSuccessful();

        $response->assertJson(fn (AssertableJson $json) => $json->has('data.0.AccountID')->etc());

        $response->assertJsonCount(5, 'data');
    }
}
