<?php

use Illuminate\Support\Facades\Route;
use Modules\Xero\Http\Controllers\XeroAccountController;
use Modules\Xero\Http\Controllers\XeroContactController;
use Modules\Xero\Http\Controllers\XeroIntegrationController;
use Modules\Xero\Http\Controllers\XeroTaxRateController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->prefix('/xero')->name('xero.')->group(function () {
    Route::get('authorize', [XeroIntegrationController::class, 'generateOAuthUrl']);
    Route::prefix('accounts')->name('accounts.')->group(function () {
        Route::get('/', [XeroAccountController::class, 'index']);
        Route::post('/download', [XeroAccountController::class, 'download']);
        Route::post('/create-nominal-codes', [XeroAccountController::class, 'createNominalCodes']);
    });
    Route::prefix('tax-rates')->name('tax-rates.')->group(function () {
        Route::get('/', [XeroTaxRateController::class, 'index']);
        Route::post('/download', [XeroTaxRateController::class, 'download']);
    });
    Route::prefix('contacts')->name('contacts.')->group(function () {
        Route::post('/sync', [XeroContactController::class, 'sync']);
    });
});
