<?php

namespace Modules\Xero\Repositories;

use App\Models\TaxRate;
use Modules\Xero\Entities\XeroTaxRate;

class XeroTaxRateRepository
{
    public function getXeroTaxRate(?int $tax_rate_id): mixed
    {
        return $tax_rate_id ? TaxRate::query()->find($tax_rate_id)->accountingIntegration : null;
    }

    public function syncTaxRate(\Modules\Xero\DTO\XeroTaxRate $taxRate): XeroTaxRate
    {
        if (is_null($xeroTaxRate = XeroTaxRate::query()->where('Name', $taxRate->Name)->first())) {
            $xeroTaxRate = new XeroTaxRate();
        }
        $xeroTaxRate->json_object = $taxRate->json_object;
        $xeroTaxRate->save();

        return $xeroTaxRate;
    }
}
