<?php

namespace Modules\Xero\Repositories;

use Illuminate\Database\Eloquent\Collection;
use Modules\Xero\DTO\XeroAccount as XeroAccountDto;
use Modules\Xero\Entities\XeroAccount;

class XeroAccountRepository
{
    public function syncAccount(XeroAccountDto $account): XeroAccount
    {
        /** @var XeroAccount $xeroAccount */
        $xeroAccount = XeroAccount::query()->firstOrNew(
            [
                'AccountID' => $account->AccountID,
            ]
        );
        $xeroAccount->json_object = json_encode($account->json_object);
        $xeroAccount->save();

        return $xeroAccount;
    }

    public function getAccountsWithoutNominalCodesIn(array $ids): Collection
    {
        return XeroAccount::leftJoinRelationship('nominalCode')
            ->whereNull('nominal_codes.id')
            ->whereIn('xero_accounts.id', $ids)
            ->get();
    }
}
