<?php

namespace Modules\Xero\Providers;

use App\Providers\ModuleServiceProvider;
use Modules\Xero\Console\XeroDownloadAccountsCommand;
use Modules\Xero\Console\XeroGetTransactionsCommand;
use Modules\Xero\Console\XeroSyncPaymentsCommand;
use Modules\Xero\Console\XeroSyncSuppliersCommand;
use Modules\Xero\Console\XeroSyncTransactionsCommand;

class XeroServiceProvider extends ModuleServiceProvider
{

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register(): void
    {
        parent::register();

        $this->commands([
            XeroSyncTransactionsCommand::class,
            XeroSyncPaymentsCommand::class,
            XeroDownloadAccountsCommand::class,
            XeroGetTransactionsCommand::class,
            XeroSyncSuppliersCommand::class
        ]);

        $this->app->register(RouteServiceProvider::class);
    }

    protected function moduleName(): string
    {
        return 'Xero';
    }

    protected function moduleNameLower(): string
    {
        return 'xero';
    }


}
