<?php

namespace Modules\Xero\Jobs;

use Modules\Xero\Managers\XeroManager;

class XeroSyncPaymentsJob extends XeroJob
{
    private array $payment_ids;

    public function __construct(array $payment_ids = [])
    {
        parent::__construct();

        $this->onQueue('xero');

        $this->payment_ids = $payment_ids;
    }

    public function apiCall()
    {
        $manager = app(XeroManager::class);
        $manager->syncPayments($this->payment_ids);
    }
}
