<?php

namespace Modules\Xero\Jobs;

use App\Jobs\Middleware\ActiveIntegrationInstanceStatusMiddleware;
use App\Models\IntegrationInstance;
use App\Repositories\IntegrationInstanceRepository;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Modules\Xero\Exceptions\XeroApiGeneralException;
use Modules\Xero\Exceptions\XeroReauthorizeException;
use Modules\Xero\Exceptions\XeroTimeoutException;
use Modules\Xero\Managers\XeroManager;

abstract class XeroJob implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    public int $timeout = 15 * 60;

    public int $maxExceptions = 2; //If same error happens 2 times then we need to stop job.

    protected XeroManager $manager;

    public IntegrationInstance $integrationInstance;

    abstract public function apiCall();

    public function __construct()
    {
        $this->manager = app(XeroManager::class);

        $this->integrationInstance = app(IntegrationInstanceRepository::class)->getAccountingInstance();
    }

    /**
     * Execute the job.
     * @return void
     * @throws Exception
     */
    public function handle(): void
    {
        try {
            $this->apiCall();
        } catch (XeroTimeoutException|XeroApiGeneralException) {
            $this->release(2);

            return;
        } catch (XeroReauthorizeException $exception) {
            throw $exception;
        } catch (Exception $exception) {
            throw $exception;
        }
    }

    public function middleware()
    {
        return [
            new ActiveIntegrationInstanceStatusMiddleware(),
        ];
    }
}
