<?php

namespace Modules\Xero\Jobs;

use Illuminate\Support\Collection;
use Modules\Xero\Repositories\XeroPaymentRepository;
use Throwable;

class XeroDeletePaymentsJob extends XeroJob
{
    public int $timeout = 60 * 30;

    public int $tries = 5;

    private Collection $payments;

    public function __construct(Collection $payments)
    {
        $this->onQueue('xero');
        $this->payments = $payments;

        parent::__construct();
    }

    /**
     * Execute the job.
     *
     * @throws Throwable
     */
    public function apiCall(): void
    {
        app(XeroPaymentRepository::class)->deleteXeroPayments($this->payments);
    }
}
