<?php

namespace Modules\Xero\Http\Controllers;

use App\Exceptions\ApiException;
use App\Http\Controllers\Controller;
use App\Response;
use GuzzleHttp\Exception\GuzzleException;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;
use Modules\Xero\Entities\XeroTaxRate;
use Modules\Xero\Exceptions\XeroReauthorizeException;
use Modules\Xero\Exceptions\XeroTimeoutException;
use Modules\Xero\Managers\XeroManager;
use Modules\Xero\Transformers\XeroTaxRateResource;

class XeroTaxRateController extends Controller
{
    public function __construct(private readonly XeroManager $manager)
    {
        parent::__construct();
    }

    /**
     * @throws GuzzleException
     */
    public function download(): ?Response
    {
        try {
            $this->manager->downloadTaxRates();

            return $this->response->success(message: 'Xero Tax Rates downloaded successfully.');
        } catch (ApiException $e) {
            return $this->response->addError(
                'There was a problem downloading Xero Tax Rates: '.$e->getMessage(),
                500,
                'DownloadXeroTaxRates'
            );
        } catch (XeroReauthorizeException $e) {
            return $this->response->addError(
                'Xero authorization has expired and must be reauthorized.',
                'XeroReauthorize',
                'XeroReauthorize'
            );
        } catch (XeroTimeoutException $e) {
            return $this->response->addError(
                $e->getMessage(),
                'XeroTimeout',
                'XeroTimeout'
            );
        }
    }

    public function index(): AnonymousResourceCollection
    {
        return XeroTaxRateResource::collection(XeroTaxRate::all());
    }
}
