<?php

namespace Modules\Xero\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\IntegrationInstance;
use App\Repositories\IntegrationInstanceRepository;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\RedirectResponse;
use Illuminate\Routing\Redirector;
use Modules\Xero\Entities\XeroIntegrationInstance;
use Modules\Xero\Services\Client;

class XeroIntegrationController extends Controller
{
    protected Client $client;

    protected XeroIntegrationInstance|IntegrationInstance $instance;

    /**
     * @throws Exception
     */
    public function __construct(IntegrationInstanceRepository $integrationInstances)
    {
        parent::__construct();

        $instance = $integrationInstances->getAccountingInstance();

        if ($instance instanceof IntegrationInstance) {
            $this->instance = $instance;
        } else {
            return;
        }

        $this->client = new Client($this->instance);
    }

    public function redirectToOAuthUrl(Redirector $redirect): RedirectResponse
    {
        return $redirect->to($this->client->getAuthorizationUrl());
    }

    public function generateOAuthUrl(): string
    {
        return $this->client->getAuthorizationUrl();
    }

    public function callback(Redirector $redirect): JsonResponse|RedirectResponse
    {
        try {
            $this->validate(request(), [
                'code' => ['required', 'string'],
            ]);

            $options = request()->only('code');

            $this->client->token('authorization_code', $options);

            $url = '/integrations/xero/'.$this->instance->id.'/dashboard';

            return $redirect->to($url);
        } catch (Exception $exception) {
            return response()->json(
                [
                    'status' => 'failed',
                    'message' => $exception->getMessage(),
                ]
            );
        }
    }
}
