<?php

namespace Modules\Xero\Exceptions;

use App\Enums\IntegrationInstanceSyncStatusEnum;
use App\Managers\IntegrationInstanceManager;
use App\Models\IntegrationInstance;
use Exception;

class XeroReauthorizeException extends Exception
{
    public function __construct(protected IntegrationInstance $integrationInstance)
    {
        app(IntegrationInstanceManager::class)->updateSyncStatus($integrationInstance, IntegrationInstanceSyncStatusEnum::INACTIVE);

        parent::__construct('Xero must be reauthorized.');
    }
}
