<?php

namespace Modules\Xero\Entities;

use App\Models\Concerns\BulkImport;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * @property int $id
 * @property string $ManualJournalID
 * @property Carbon $DateUTC
 * @property Carbon $UpdatedDateUTC,
 * @property string $Status,
 * @property string $Narration,
 * @property array $json_object
 * @property Carbon $updated_at
 * @property Carbon $created_at
 */
class XeroManualJournal extends Model
{
    use BulkImport;

    const BULK_THRESHOLD = 50;

    protected $guarded = [];

    protected $casts = [
        'json_object' => 'array',
    ];
}
