<?php

namespace Modules\Xero\Entities;

use App\Models\Integration;
use App\Models\IntegrationInstance;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;

class XeroIntegrationInstance extends IntegrationInstance
{
    protected $table = 'integration_instances';

    protected $primaryKey = 'id';

    protected static function booted()
    {
        static::addGlobalScope('xero', function (Builder $builder) {
            return $builder->whereHas('integration', function ($q) {
                $q->where('name', Integration::NAME_XERO);
            });
        });
    }

    public function hasRemainingDailyApiCalls(): bool
    {
        if (! isset($this->integration_settings['remainingApiUsage'])) {
            return true;
        }
        $dailyResetAt = isset($this->integration_settings['dailyResetAt']) ? Carbon::parse($this->integration_settings['dailyResetAt']) : Carbon::now();
        if ($this->integration_settings['remainingApiUsage'] == 0 && Carbon::now()->lt($dailyResetAt)) {
            return false;
        }

        return true;
    }
}
