<?php

namespace Modules\Xero\Entities;

use App\Services\Accounting\AccountingIntegration;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;

/**
 * @property int $id
 * @property string $ContactID
 * @property string $Name
 * @property int $link_id
 * @property string $link_type
 * @property array $last_error,
 * @property array $json_object
 * @property string $link
 * @property Carbon $last_synced_at
 * @property Carbon $updated_at
 * @property Carbon $created_at
 */
class XeroContact extends Model implements AccountingIntegration
{
    use HasFactory;

    protected $fillable = [
        'link_id',
        'link_type',
        'json_object',
    ];

    protected $casts = [
        'last_error' => 'array',
    ];

    public function link(): MorphTo
    {
        return $this->morphTo('link');
    }

    public function lastSyncedAt(): Attribute
    {
        return Attribute::get(fn () => $this->updated_at);
    }

    public function getLastSyncedAt(): ?Carbon
    {
        return $this->last_synced_at;
    }

    public function getLastError(): ?array
    {
        return $this->last_error;
    }

    public function getLink(): ?string
    {
        return $this->link;
    }
}
