<?php

namespace Modules\Xero\Entities;

use App\Models\Concerns\HasFilters;
use App\Models\Contracts\Filterable;
use App\Models\NominalCode;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Kirschbaum\PowerJoins\PowerJoins;
use Modules\Xero\Database\factories\XeroAccountFactory;

/**
 * @property int $id
 * @property string $AccountID
 * @property string $Code
 * @property string $Name
 * @property string $Type
 * @property string $Status
 * @property string $Class
 * @property array $json_object
 * @property-read NominalCode $nominalCode
 * @property Carbon $updated_at
 * @property Carbon $created_at
 */
class XeroAccount extends Model implements Filterable
{
    use HasFactory;
    use HasFilters;
    use PowerJoins;

    protected $fillable = [
        'AccountID',
        'json_object',
    ];

    const TYPE_BANK = 'BANK';

    const TYPE_CURRENT = 'CURRENT';

    const TYPE_CURRLIAB = 'CURRLIAB';

    const TYPE_DEPRECIATN = 'DEPRECIATN';

    const TYPE_DIRECTCOSTS = 'DIRECTCOSTS';

    const TYPE_EQUITY = 'EQUITY';

    const TYPE_EXPENSE = 'EXPENSE';

    const TYPE_FIXED = 'FIXED';

    const TYPE_INVENTORY = 'INVENTORY';

    const TYPE_LIABILITY = 'LIABILITY';

    const TYPE_NONCURRENT = 'NONCURRENT';

    const TYPE_OTHERINCOME = 'OTHERINCOME';

    const TYPE_OVERHEADS = 'OVERHEADS';

    const TYPE_PREPAYMENT = 'PREPAYMENT';

    const TYPE_REVENUE = 'REVENUE';

    const TYPE_SALES = 'SALES';

    const TYPE_TERMLIAB = 'TERMLIAB';

    const TYPE_PAYGLIABILITY = 'PAYGLIABILITY';

    const TYPE_SUPERANNUATIONEXPENSE = 'SUPERANNUATIONEXPENSE';

    const TYPE_SUPERANNUATIONLIABILITY = 'SUPERANNUATIONLIABILITY';

    const TYPE_WAGESEXPENSE = 'WAGESEXPENSE';

    const TYPE_NOMINAL_CODE_MAPPINGS = [
        self::TYPE_BANK => NominalCode::TYPE_BANK,
        self::TYPE_CURRENT => NominalCode::TYPE_CURRENT,
        self::TYPE_CURRLIAB => NominalCode::TYPE_CURRLIAB,
        self::TYPE_DEPRECIATN => NominalCode::TYPE_EXPENSE,
        self::TYPE_DIRECTCOSTS => NominalCode::TYPE_DIRECTCOSTS,
        self::TYPE_EQUITY => NominalCode::TYPE_EQUITY,
        self::TYPE_EXPENSE => NominalCode::TYPE_EXPENSE,
        self::TYPE_FIXED => NominalCode::TYPE_FIXED,
        self::TYPE_INVENTORY => NominalCode::TYPE_INVENTORY,
        self::TYPE_LIABILITY => NominalCode::TYPE_LIABILITY,
        self::TYPE_NONCURRENT => NominalCode::TYPE_LIABILITY,
        self::TYPE_OTHERINCOME => NominalCode::TYPE_REVENUE,
        self::TYPE_OVERHEADS => NominalCode::TYPE_EXPENSE,
        self::TYPE_PREPAYMENT => NominalCode::TYPE_LIABILITY,
        self::TYPE_REVENUE => NominalCode::TYPE_REVENUE,
        self::TYPE_SALES => NominalCode::TYPE_REVENUE,
        self::TYPE_TERMLIAB => NominalCode::TYPE_LIABILITY,
        self::TYPE_PAYGLIABILITY => NominalCode::TYPE_LIABILITY,
        self::TYPE_SUPERANNUATIONEXPENSE => NominalCode::TYPE_EXPENSE,
        self::TYPE_SUPERANNUATIONLIABILITY => NominalCode::TYPE_LIABILITY,
        self::TYPE_WAGESEXPENSE => NominalCode::TYPE_EXPENSE,
    ];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function nominalCode(): HasOne
    {
        return $this->hasOne(NominalCode::class, 'code', 'Code');
    }

    public function availableColumns()
    {
        return config('data_table.xero_account.columns');
    }

    public function filterableColumns(): array
    {
        return collect($this->availableColumns())->where('filterable', 1)->pluck('data_name')->all();
    }

    public function generalFilterableColumns(): array
    {
        return ['Name'];
    }

    protected static function newFactory()
    {
        return XeroAccountFactory::new();
    }
}
