<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('xero_transactions', function (Blueprint $table) {
            $table->string('status')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.Status'))")->after('type');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('xero_transactions', function (Blueprint $table) {
            $table->dropColumn('status');
        });
    }
};
