<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::dropIfExists('xero_tax_rates');
        Schema::create('xero_tax_rates', function (Blueprint $table) {
            $table->id();
            $table->string('Name')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.Name'))");
            $table->string('TaxType')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.TaxType'))");
            $table->decimal('EffectiveRate', 12, 4)->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.EffectiveRate'))");
            $table->json('json_object')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('xero_tax_rates');
    }
};
