<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('xero_contacts', function (Blueprint $table) {
            $table->id();
            $table->string('ContactID')->unique()->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.ContactID'))");
            $table->string('Name')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.Name'))");
            $table->unsignedBigInteger('link_id')->nullable();
            $table->string('link_type')->nullable();
            $table->json('last_error')->nullable();
            $table->json('json_object')->nullable();
            $table->timestamps();
            $table->unique(['link_id', 'link_type']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('xero_contacts');
    }
};
