<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('xero_accounts', function (Blueprint $table) {
            $table->id();
            $table->string('AccountID')->unique();
            $table->string('Name')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.Name'))");
            $table->string('Code')->unique()->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.Code'))");
            $table->string('Type')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.Type'))");
            $table->string('Status')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.Status'))");
            $table->string('Class')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.Class'))");
            $table->json('json_object');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('xero_accounts');
    }
};
