<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::dropIfExists('xero_transactions');

        Schema::create('xero_transactions', function (Blueprint $table) {
            $table->id();
            $table->string('xero_uuid')->unique()->nullable();
            $table->string('type');
            $table->json('last_error')->nullable();
            $table->json('json_object')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('xero_transactions');
    }
};
